/*
 * crcAuto.h
 *
 *  Created on: May 18, 2016
 *      Author: a0406448
 */

#ifndef CRCSEMICPU_H_
#define CRCSEMICPU_H_

/* HALCoGen Register Definition Includes Files */
#include "sys_common.h"
#include "sys_dma.h"
#include "sys_pmu.h"

/* HALCoGen Drivers Include Files */
#include "crc.h"
#include "rti.h"

/* CG Tools Include Files */
#include <crc_tbl.h>
#include <stdio.h>

/* Hash Defines */
#ifndef crcREG
#define crcREG crcREG1
/* Note: This is just a helper to identify RM57 and LC43 devices, as they need different handling for the DMA */
#define RM57_OR_LC43
#else
#undef crcREG1
#undef crcREG2
#undef RM57_OR_LC43
#endif

/* Type Definitions */
typedef struct
{
	const CRC_TABLE  * const g_crcTable;
	sint32 i32LastEntry;
	bool   bInitialized;
#ifdef RM57_OR_LC43
	dmaChannel_t eDmaChannel;
#else
	enum   dmaCHANNEL eDmaChannel;
#endif
	uint32 u32DmaRequLine;
} g_crcSemiCpuCtrl;

/* Function Prototypes */
void crcSemiCpuMode(crcBASE_t *crc, g_crcSemiCpuCtrl * crcSemiCpuCtrl);

#endif /* CRCSEMICPU_H_ */
